//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#include "C_Terminal.mqh"
//+------------------------------------------------------------------+
class C_PanelText
{
	protected:
		struct stTextSize
			{
				int 	width,
						height;
			};
	private	:
		int		m_width,
					m_height;
		uint		m_Pixel[];
		string	m_szObjName,
					m_szRcName;
		long 		m_id;
		stTextSize m_TextInfos;
	public	:
//+------------------------------------------------------------------+
		C_PanelText(int x, int y, int w, int h, string szFont, int FontSize, int sub = 0)
			:m_szObjName(NULL),
			 m_szRcName(NULL)
			{			
				m_id = ChartID();
				ResetLastError();
				TextSetFont(szFont, FontSize, 0, 0);
				TextGetSize("M", m_TextInfos.width, m_TextInfos.height);
				if (((m_width = w) > 0) && ((m_height = h) > 0) && (ArrayResize(m_Pixel, w * h) > 0))
				{
					m_szRcName = "::" + (m_szObjName = "C_PanelText_" + (string)ObjectsTotal(m_id));
					if (ObjectCreate(m_id, m_szObjName, OBJ_BITMAP_LABEL, sub, 0, 0))	return;
				}
				SetUserError(C_Terminal::ERR_Unknown);
			}
//+------------------------------------------------------------------+
		~C_PanelText()
			{
				ArrayFree(m_Pixel);
				ObjectDelete(m_id, m_szObjName);
				ResourceFree(m_szRcName);
			}
//+------------------------------------------------------------------+
const int Resize(int x, int y, uchar fw, int h)
			{
				m_width = (fw * m_TextInfos.width);
				m_height = h;
				ObjectSetInteger(m_id, m_szObjName, OBJPROP_XDISTANCE, x - m_width);
				ObjectSetInteger(m_id, m_szObjName, OBJPROP_YDISTANCE, y);
				ArrayResize(m_Pixel, m_width * h);
				
				return m_width;
			}
//+------------------------------------------------------------------+
		void Update(void)
			{
				if (m_szRcName == NULL) return;
				if (ResourceCreate(m_szRcName, m_Pixel, m_width, m_height, 0, 0, 0, COLOR_FORMAT_ARGB_NORMALIZE))
				{
					ObjectSetString(m_id, m_szObjName, OBJPROP_BMPFILE, m_szRcName);
					ChartRedraw();
				}
			}
//+------------------------------------------------------------------+
inline void Erase(const uint clr = clrWhite, const uint ts = 0) { ArrayInitialize(m_Pixel, macroColorRGBA(clr, ts)); }
//+------------------------------------------------------------------+
inline const stTextSize TextOutFast(int x, int y, string text, const uint clr)
			{
				TextOut(text, x, y, 0, m_Pixel, m_width, m_height, clr, COLOR_FORMAT_ARGB_NORMALIZE);
				return m_TextInfos;
			}
//+------------------------------------------------------------------+
};
//+------------------------------------------------------------------+
